<?php $totalRecords = App\Models\History::all()->count(); ?>
@if ($paginator->hasPages())
    <ul class="flex justify-around p-5 text-gray-500 text-sm font-medium">
        @if ($paginator->onFirstPage())
            <li class="paginate-disable text-gray-300">Prev</li>
        @else
            <li class="cursor-pointer px-3 py-1 border rounded-md hover:bg-gray-200" wire:click="previousPage">Prev</li>
        @endif
            <li class="font-light text-xs flex justify-center items-center">{{ $totalRecords }} total records</li>
        @if ($paginator->hasMorePages())
            <li class="cursor-pointer px-3 py-1 border rounded-md hover:bg-gray-200" wire:click="nextPage">Next</li>
        @else
            <li class="paginate-disable text-gray-300">Next</li>
        @endif
    </ul>
@endif