<!DOCTYPE html>
<html class="scroll-smooth" lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Brazil Pools</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon.png') }}">
    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-color-color1">
    <div id="onDrawing" class="fixed hidden justify-center items-center w-screen h-screen z-[120] bg-color-color1">
        <img class="w-[280px]" src="{{ asset('assets/img/logo.png') }}" alt="Please wait..">
    </div>
    <div id="main-wrapper" class="font-joti">
        <section id="header">
            <div class="mx-auto max-w-[1000px]">
                <div class="grid lg:grid-cols-2 p-5 border-b-[1px] border-color-color3">
                    <div class="flex lg:justify-start lg:items-center justify-center lg:my-0 my-5">
                        <a href="/">
                            <img class="w-[230px]" src="{{ asset('assets/img/logo.png') }}" alt="Logo">
                        </a>
                    </div>
                    <div class="flex justify-end items-center">
                        <ul class="flex justify-center lg:space-x-20 space-x-10 font-bold text-lg bg-color-color2 rounded-full p-3 w-full text-color-color4">
                            <li><a class="{{ request()->is('/') ? 'text-color-color5' : 'text-color-color4' }}" href="/">Home</a></li>
                            <li><a class="{{ request()->is('results') ? 'text-color-color5' : 'text-color-color4' }}" href="/results">Results</a></li>
                            <li><a class="{{ request()->is('about-us') ? 'text-color-color5' : 'text-color-color4' }}" href="/about-us">About Us</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>