<?php

namespace App\Livewire\Frontend;
use App\Models\History as ModelsHistory;
use App\Models\Misc as ModelsMisc;
use Livewire\WithPagination;
use Livewire\Component;

class Results extends Component
{   
    use WithPagination;
    public $keyword;
    public $miscdata;

    public function render()
    {   
        if($this->keyword != null) {
            $data = ModelsHistory::where('p_1st', 'like', '%' .$this->keyword. '%')
            ->orwhere('date', 'like', '%' .$this->keyword. '%')
            ->orwhere('day', 'like', '%' .$this->keyword. '%')
            ->orderBy('id', 'desc')->paginate(8);
        } else {
            $data = ModelsHistory::orderBy('id', 'desc')->paginate(8);
        }
        return view('livewire.frontend.results', ['dataResults' => $data]);
    }

    public function mount()
    {   
        $this->miscdata = ModelsMisc::where('id', 1)->first(); 
    }

}