<?php

namespace App\Livewire\Backend;
use App\Models\Keluaran as ModelsKeluaran;
use Carbon\Carbon;
use App\Models\Misc as ModelsMisc;
use Livewire\Component;

class Keluaran extends Component
{   
    public $timerEnd;
    public $timerId = 1;
    public $miscdata;
    public $dateNumbers;
    public $numbers;
    public $fourdata;

    public function render()
    {
        return view('livewire.backend.keluaran');
    }

    public function mount()
    {   
        $today = date('Y-m-d 19:30:00');
        $this->timerEnd = date('Y-m-d 19:30:00', strtotime($today . '+1 day'));
        $this->dateNumbers = date('Y-m-d', strtotime($today . '+1 day'));
        $this->numbers = '';
        $this->miscdata = ModelsMisc::where('id', 1)->first(); 
        $this->load4();
    }

    public function load4()
    {
        $this->fourdata = ModelsKeluaran::orderBy('id', 'desc')->limit(4)->get();
    }

    public function generate4d()
    {
        $this->numbers = mt_rand(1000, 9999);
    }

    public function insertNumber()
    {
        $rules = [
            'dateNumbers' => 'required',
            // 'numbers' => 'required|unique:index_draw_results,p_1st',
            'numbers' => 'required',
        ];

        $messages = [
            'dateNumbers.required' => 'Tanggal harus di isi',
            'numbers.required' => 'Nomor harus di isi',
            // 'numbers.unique' => 'Nomor sudah ada, silahkan ganti dengan nomor lain',
        ];

        $this->validate($rules, $messages);

        ModelsKeluaran::create([
            'date' => $this->dateNumbers,
            'day' => Carbon::parse($this->dateNumbers)->format('D'),
            'p_1st' => $this->numbers,
        ]);

        session()->flash('message', 'Insert keluaran sukses!');
        $this->mount();
    }

    public function setTimer()
    {   
        $rules = [
            'timerEnd' => 'required',
        ];

        $messages = [
            'timerEnd.required' => 'Tanggal & waktu harus di isi',
        ];

        $this->validate($rules, $messages);
        $data = ModelsMisc::find($this->timerId);

        $data->update([
            'timer_end' => $this->timerEnd,
        ]);

        session()->flash('message', 'Set Timer Sukses!');
        $this->mount();
    }
}
