<?php

namespace App\Livewire\Backend;
use App\Models\History as ModelsHistory;
use Carbon\Carbon;
use Livewire\WithPagination;
use Livewire\Component;

class History extends Component
{   
    use WithPagination;
    public $numbers;
    public $date;
    public $day;
    public $idKeluaran;
    public $keyword;
    public $updateData = false;

    public function render()
    {   
        if($this->keyword != null) {
            $data = ModelsHistory::where('p_1st', 'like', '%' .$this->keyword. '%')
            ->orwhere('date', 'like', '%' .$this->keyword. '%')
            ->orwhere('day', 'like', '%' .$this->keyword. '%')
            ->orderBy('id', 'desc')->paginate(8);
        } else {
            $data = ModelsHistory::orderBy('id', 'desc')->paginate(12);
        }
        return view('livewire.backend.history', ['dataHistory' => $data]);
    }

    public function cancelUpdate()
    {
        $this->updateData = false;
        $this->clear();
    }

    public function generate4d()
    {
        $this->numbers = mt_rand(1000, 9999);
    }

    public function edit($id)
    {
        $data = ModelsHistory::find($id);
        $this->numbers = $data->p_1st;
        $this->date = $data->date;
        $this->day = $data->day;
        $this->idKeluaran = $id;
        $this->updateData = true;
    }

    public function update()
    {
        $rules = [
            // 'numbers' => 'required|unique:index_draw_results,p_1st',
            'numbers' => 'required',
            'date' => 'required',
        ];

        $messages = [
            'numbers.required' => 'Nomor harus di isi',
            // 'numbers.unique' => 'Nomor sudah ada, silahkan ganti dengan nomor lain',
            'date.required' => 'Tanggal harus di isi',
        ];

        $data = ModelsHistory::find($this->idKeluaran);

        if($this->numbers == $data->p_1st && $this->date == $data->date) {
            session()->flash('message', 'Tidak ada perubahan data!');
            $this->updateData = false;
            return;
        }
        if($this->numbers == $data->p_1st && $this->date != $data->date) {
            $data->update([
                'date' => $this->date,
                'day' => Carbon::parse($this->date)->format('D'),
                'p_1st' => $this->numbers,
            ]);
        } 
        else {
            $this->validate($rules, $messages);
            $data->update([
                'date' => $this->date,
                'day' => Carbon::parse($this->date)->format('D'),
                'p_1st' => $this->numbers,
            ]);
        }

        session()->flash('message', 'Update keluaran sukses!');
        $this->updateData = false;
        $this->clear();
    }

    public function delete($id)
    {
        ModelsHistory::find($id)->delete();
        session()->flash('message', 'Delete keluaran sukses!');
        $this->clear();
    }

    public function clear()
    {
        $this->numbers = '';
        $this->date = '';
        $this->day = '';
        $this->idKeluaran = null;
    }

}